
close all

h_hamilton = 8; % horizon for hamilton detrending: 8 for quarterly
p_hamilton = 3; % number of most recent values of variable
%% JOLTS
JOLTS = readtable('../Data/JOLTS/JOLTS.csv');
startDate = datenum('12-01-2000');
endDate = datenum('09-01-2018');
tGrid = linspace(startDate,endDate,214)';
JOLTS.date = tGrid;

JOLTS.qrtD = 10*year(JOLTS.date) + quarter(JOLTS.date);

JOLTS_HIR_qrt = splitapply(@mean,JOLTS.HIR,findgroups(JOLTS.qrtD));
JOLTS_QUR_qrt = splitapply(@mean,JOLTS.QUR,findgroups(JOLTS.qrtD));
JOLTS_JOR_qrt = splitapply(@mean,JOLTS.JOR,findgroups(JOLTS.qrtD));
JOLTS_date_qrt = linspace(datenum('12-01-2000'),datenum('09-01-2018'),72)';

hpParam = 129600;
hpParamQrt = 1600;

[~,JOLTS.QUR_cyc] = hpfilter(JOLTS.QUR,hpParam);
[~,JOLTS.HIR_cyc] = hpfilter(JOLTS.HIR,hpParam);
[~,JOLTS.JOR_cyc] = hpfilter(JOLTS.JOR,hpParam);

[~,JOLTS_QUR_cyc] = hpfilter(JOLTS_QUR_qrt,hpParamQrt);
[~,JOLTS_HIR_cyc] = hpfilter(JOLTS_HIR_qrt,hpParamQrt);
[~,JOLTS_JOR_cyc] = hpfilter(JOLTS_JOR_qrt,hpParamQrt);


[~,~,JOLTS_QUR_cyc_hamilton] = regress(JOLTS_QUR_qrt,[ones(size(JOLTS_QUR_qrt)) lagmatrix(JOLTS_QUR_qrt,h_hamilton:p_hamilton+h_hamilton)]);
[~,~,JOLTS_HIR_cyc_hamilton] = regress(JOLTS_HIR_qrt,[ones(size(JOLTS_HIR_qrt)) lagmatrix(JOLTS_HIR_qrt,h_hamilton:p_hamilton+h_hamilton)]);
[~,~,JOLTS_JOR_cyc_hamilton] = regress(JOLTS_JOR_qrt,[ones(size(JOLTS_JOR_qrt)) lagmatrix(JOLTS_JOR_qrt,h_hamilton:p_hamilton+h_hamilton)]);

%% LTS
LTS = readtable('../Data/LTS/LTS.csv');
LTS.JOR = str2double(LTS.JOR);
startDate = datenum('01-01-1959');
endDate = datenum('12-01-1981');
tGrid = linspace(startDate,endDate,276);
LTS.date = tGrid';
LTS.qrtD = 10 * year(LTS.date) + quarter(LTS.date);

LTS_HIR_qrt = splitapply(@mean,LTS.HIR,findgroups(LTS.qrtD));
LTS_QUR_qrt = splitapply(@mean,LTS.QUR,findgroups(LTS.qrtD));
LTS_JOR_qrt = splitapply(@mean,LTS.JOR,findgroups(LTS.qrtD));
LTS_date_qrt = linspace(datenum('01-01-1959'),datenum('12-01-1981'),92)';
LTSqrt  = [quarter(LTS_date_qrt) year(LTS_date_qrt)];

[~,LTS.QUR_cyc] = hpfilter(LTS.QUR,hpParam);
[~,LTS.HIR_cyc] = hpfilter(LTS.HIR,hpParam);
[~,LTS.JOR_cyc((124:180))] = hpfilter(LTS.JOR(124:180),hpParam);
LTS.JOR_cyc(LTS.JOR_cyc==0) = nan;



[~,LTS_QUR_cyc] = hpfilter(LTS_QUR_qrt,hpParamQrt);
[~,LTS_HIR_cyc] = hpfilter(LTS_HIR_qrt,hpParamQrt);
[~,LTS_JOR_cyc] = hpfilter(LTS_JOR_qrt(42:59),hpParamQrt);

LTS_JOR_cyc = [nan(41,1);LTS_JOR_cyc;nan(33,1)];

[~,~,LTS_QUR_cyc_hamilton] = regress(LTS_QUR_qrt,[ones(size(LTS_QUR_qrt)) lagmatrix(LTS_QUR_qrt,h_hamilton:p_hamilton+h_hamilton)]);
[~,~,LTS_HIR_cyc_hamilton] = regress(LTS_HIR_qrt,[ones(size(LTS_HIR_qrt)) lagmatrix(LTS_HIR_qrt,h_hamilton:p_hamilton+h_hamilton)]);
[~,~,LTS_JOR_cyc_hamilton] = regress(LTS_JOR_qrt,[ones(size(LTS_JOR_qrt)) lagmatrix(LTS_JOR_qrt,h_hamilton:p_hamilton+h_hamilton)]);

%% NBER 
NBER_JOB = readtable('../Data/NBER/JobOpenings.txt'); % in thousands
NBER_JOB.Var4 = [];
NBER_JOB.Properties.VariableNames = {'Year' 'Month' 'JOL'};
NBER_JOB.JOL = str2double(NBER_JOB.JOL);

NBER_EMP = readtable('../Data/NBER/Employment2.txt'); % in millions
NBER_EMP.Var4 = [];
NBER_EMP.Properties.VariableNames = {'Year' 'Month' 'EMP'};
NBER = outerjoin(NBER_JOB,NBER_EMP,'Keys',{'Year' 'Month'});
NBER.JOR = 100*NBER.JOL./(1000*NBER.EMP);

startDateNBER = datenum('01-01-1946');
endDateNBER = datenum('12-01-1969');
tGridNBER = linspace(startDateNBER,endDateNBER,288);
NBER.date = tGridNBER';

NBER = rmmissing(NBER);
[~,NBER.JOR_cyc] = hpfilter(NBER.JOR,hpParam);

%%

markerSize = 2;

xLabel = 'Year';
yLabel = 'Rate (\%)';
figNum = 1;

%% *** Hiring, Quit, Job Opening Rates***

figure(figNum)
plot(276+1:276+214,JOLTS.HIR,ls.lineSpec1{:})
hold on
plot(276+1:276+214,JOLTS.JOR,ls.lineSpec2{:})
plot(276+1:276+214,JOLTS.QUR,ls.lineSpec3{:})

h1 = plot(1:276,LTS.HIR,ls.lineSpec1{:});
%plot(NBER.date,NBER.JOR,lineSpec2{:},'Marker','d','MarkerSize',markerSize)
h2 = plot(1:276,LTS.JOR,ls.lineSpec2{:});
h3 = plot(1:276,LTS.QUR,ls.lineSpec3{:});
y1=get(gca,'ylim');
plot([277 277],y1,'k-','HandleVisibility','off')
hold off
xticks([1 61 121 181 253 277+13 277+73 277+133 277+193])
xticklabels({'1959','1964','1969','1974','1980','2001','2006','2011','2016'})
legend([h1 h2 h3],{'Hires','Job Openings','Quits'},'Location','best')
grid on
text(150,5.5,'LTS','FontSize',15)
text(325,5.5,'JOLTS','FontSize',15)
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
%xlabel(xLabel);
ylabel('Rate (per 100 employee)');

export_fig(figure(figNum),[ls.graphPath 'ALL_HIR_JOR_QUR'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** Hiring, Quit, Job Opening Rates Quarterly ***

figure(figNum)
plot(92+1:92+72,JOLTS_HIR_qrt,ls.lineSpec1{:})
hold on
plot(92+1:92+72,JOLTS_JOR_qrt,ls.lineSpec2{:})
plot(92+1:92+72,JOLTS_QUR_qrt,ls.lineSpec3{:})

h1 = plot(1:92,LTS_HIR_qrt,ls.lineSpec1{:});
h2 = plot(1:92,LTS_JOR_qrt,ls.lineSpec2{:});
h3 = plot(1:92,LTS_QUR_qrt,ls.lineSpec3{:});

y1=get(gca,'ylim');
plot([92 92],y1,'k-','HandleVisibility','off')
hold off
xticks([1 31 61 85 92+5 92+31 92+61])
xticklabels({'1959','1966','1974','1980','2001','2008','2015'})
legend([h1 h2 h3],{'Hires','Job Openings','Quits'},'Location','best')
grid on
text(50,5.5,'LTS','FontSize',15)
text(125,5.5,'JOLTS','FontSize',15)
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
ylabel('Rate (per 100 employee)');
axis([1 92+72 0 inf])
export_fig(figure(figNum),[ls.graphPath 'ALL_HIR_JOR_QUR_qrt'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** Cyclicality of Hires and Quits ***

yLabel2 = 'Deviation from Trend (ppt)';

figure(figNum)
h1 = plot(276+1:276+214,JOLTS.HIR_cyc,ls.lineSpec1{:});
hold on
h2 = plot(276+1:276+214,JOLTS.QUR_cyc,ls.lineSpec2{:});
plot(1:276,LTS.HIR_cyc,ls.lineSpec1{:})
plot(1:276,LTS.QUR_cyc,ls.lineSpec2{:})
y1=get(gca,'ylim');
plot([277 277],y1,'k-','HandleVisibility','off')
hold off
xticks([1 61 121 181 253 277+13 277+73 277+133 277+193])
xticklabels({'1959','1964','1969','1974','1980','2001','2006','2011','2016'})
legend([h1 h2],{'Hires','Quits'})
grid on
text(150,1.55,'LTS','FontSize',15)
text(325,1.55,'JOLTS','FontSize',15)
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
%xlabel(xLabel);
ylabel(yLabel2);


export_fig(figure(figNum),[ls.graphPath 'ALL_HIR_QUR_cyc'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** Cyclicality of Hires and Quits Quarterly ***

figure(figNum)
h1 = plot(92+1:92+72,JOLTS_HIR_cyc,ls.lineSpec1{:});
hold on
h2 = plot(92+1:92+72,JOLTS_QUR_cyc,ls.lineSpec3{:});
plot(1:92,LTS_HIR_cyc,ls.lineSpec1{:})
plot(1:92,LTS_QUR_cyc,ls.lineSpec3{:})
plot([92 92],[-1.5 1],'k-','HandleVisibility','off')
hold off
xticks([1 31 61 85 92+5 92+31 92+61])
xticklabels({'1959','1966','1974','1980','2001','2008','2015'})
legend([h1 h2],{'Hires','Quits'},'Location','southwest')
grid on
text(50,0.925,'LTS','FontSize',15)
text(110,0.925,'JOLTS','FontSize',15)
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
%xlabel(xLabel);
ylabel(yLabel2);

axis([1 92+72 -1.5 inf])

export_fig(figure(figNum),[ls.graphPath 'ALL_HIR_QUR_cyc_qrt'],'-pdf','-transparent');

figNum = figNum + 1;

[b_hp,~,~,~,stats_hp] = regress(JOLTS_HIR_cyc,[ones(length(JOLTS_QUR_cyc),1) JOLTS_QUR_cyc]);

%% *** Cyclicality of Hires and Quits Quarterly - Hamilton ***

figure(figNum)
h1 = plot(92+1:92+72,JOLTS_HIR_cyc_hamilton,ls.lineSpec1{:});
hold on
h2 = plot(92+1:92+72,JOLTS_QUR_cyc_hamilton,ls.lineSpec3{:});
plot(1:92,LTS_HIR_cyc_hamilton,ls.lineSpec1{:})
plot(1:92,LTS_QUR_cyc_hamilton,ls.lineSpec3{:})
y1=get(gca,'ylim');
plot([92 92],y1,'k-','HandleVisibility','off')
hold off
xticks([1 31 61 85 92+5 92+31 92+61])
xticklabels({'1959','1966','1974','1980','2001','2008','2015'})
legend([h1 h2],{'Hires','Quits'},'Location','southwest')
grid on
text(50,0.925,'LTS','FontSize',15)
text(110,0.925,'JOLTS','FontSize',15)
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
%xlabel(xLabel);
ylabel(yLabel2);

axis([1 92+72 -1.5 1])

export_fig(figure(figNum),[ls.graphPath 'ALL_HIR_QUR_cyc_qrt_hamilton'],'-pdf','-transparent');

figNum = figNum + 1;

[b_hamilton,~,~,~,stats_hamilton] = regress(JOLTS_HIR_cyc_hamilton,[ones(length(JOLTS_QUR_cyc_hamilton),1) JOLTS_QUR_cyc_hamilton]);

%% *** Cyclicality of Quits and Jop Openings ***
figure(figNum)
h1 = plot(276+1:276+214,JOLTS.JOR_cyc,ls.lineSpec1{:});
hold on
h2 = plot(276+1:276+214,JOLTS.QUR_cyc,ls.lineSpec2{:});
plot(124:180,LTS.JOR_cyc(124:180),ls.lineSpec1{:})
plot(1:276,LTS.QUR_cyc,ls.lineSpec2{:})
y1=get(gca,'ylim');
plot([277 277],y1,'k-','HandleVisibility','off')
hold off
xticks([1 61 121 181 253 277+13 277+73 277+133 277+193])
xticklabels({'1959','1964','1969','1974','1980','2001','2006','2011','2016'})
%plot(NBER.date,NBER.JOR_cyc,lineSpec1{:},'Marker','d','MarkerSize',markerSize)
hold off
%datetick('x','yy')
legend([h1 h2],'Jop Openings','Quits')
grid on
text(150,1.05,'LTS','FontSize',15)
text(325,1.05,'JOLTS','FontSize',15)
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
%xlabel(xLabel);
ylabel(yLabel2);


export_fig(figure(figNum),[ls.graphPath 'ALL_JOR_QUR_cyc'],'-pdf','-transparent');

figNum = figNum + 1;


%% *** Cyclicality of Quits and Jop Openings Quarterly ***
figure(figNum)
h1 = plot(92+1:92+72,JOLTS_JOR_cyc,ls.lineSpec2{:});
hold on
h2 = plot(92+1:92+72,JOLTS_QUR_cyc,ls.lineSpec3{:});
plot(42:59,LTS_JOR_cyc(42:59),ls.lineSpec2{:})
plot(1:92,LTS_QUR_cyc,ls.lineSpec3{:})
plot([92 92],[-2 1.5],'k-','HandleVisibility','off')
hold off
xticks([1 31 61 85 92+5 92+31 92+61])
xticklabels({'1959','1966','1974','1980','2001','2008','2015'})
%plot(NBER.date,NBER.JOR_cyc,lineSpec1{:},'Marker','d','MarkerSize',markerSize)
hold off
legend([h1 h2],'Jop Openings','Quits','Location','southwest')
grid on
text(50,0.7,'LTS','FontSize',15)
text(110,0.7,'JOLTS','FontSize',15)
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
%xlabel(xLabel);
ylabel(yLabel2);
axis([1 92+72 -2 1.5])


export_fig(figure(figNum),[ls.graphPath 'ALL_JOR_QUR_cyc_qrt'],'-pdf','-transparent');

figNum = figNum + 1;

[b2_hp,~,~,~,stats2_hp] = regress(JOLTS_JOR_cyc,[ones(length(JOLTS_QUR_cyc),1) JOLTS_QUR_cyc]);

%% *** Cyclicality of Quits and Jop Openings Quarterly - Hamilton ***
figure(figNum)
h1 = plot(92+1:92+72,JOLTS_JOR_cyc_hamilton,ls.lineSpec2{:});
hold on
h2 = plot(92+1:92+72,JOLTS_QUR_cyc_hamilton,ls.lineSpec3{:});
plot(42:59,LTS_JOR_cyc_hamilton(42:59),ls.lineSpec2{:})
plot(1:92,LTS_QUR_cyc_hamilton,ls.lineSpec3{:})
y1=get(gca,'ylim');
plot([92 92],y1,'k-','HandleVisibility','off')
hold off
xticks([1 31 61 85 92+5 92+31 92+61])
xticklabels({'1959','1966','1974','1980','2001','2008','2015'})
%plot(NBER.date,NBER.JOR_cyc,lineSpec1{:},'Marker','d','MarkerSize',markerSize)
hold off
legend([h1 h2],'Jop Openings','Quits','Location','southwest')
grid on
text(50,0.7,'LTS','FontSize',15)
text(110,0.7,'JOLTS','FontSize',15)
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
%xlabel(xLabel);
ylabel(yLabel2);
axis([1 92+72 -2 1.5])


export_fig(figure(figNum),[ls.graphPath 'ALL_JOR_QUR_cyc_qrt_hamilton'],'-pdf','-transparent');

figNum = figNum + 1;
[b2_hamilton,~,~,~,stats2_hamilton] = regress(JOLTS_JOR_cyc_hamilton,[ones(length(JOLTS_QUR_cyc_hamilton),1) JOLTS_QUR_cyc_hamilton]);


